# Script to enable DEP on clients with and without Bitlocker

$script:ErrorActionPreference = "SilentlyContinue"
$DebugPreference = "Continue"

$ScriptPath = $MyInvocation.MyCommand.Path
$ScriptDir = split-path -parent $ScriptPath
$ScriptName = ($MyInvocation.MyCommand.Name).SubString(0,($MyInvocation.MyCommand.Name).Length-4)

# Function to write Logfile

Function Log($text)
{

	$suffix = "{0:d}" -f [System.DateTime]::get_Now()


	if ( $LogPath -eq $NULL )
	{
		$Global:LogPath = "$env:windir\Logs\$Scriptname"

	}


	if ( $LogFile -eq $NULL )
	{
		$Global:Logfile = "$LogPath\$Scriptname" + "_" + $suffix + ".log"
	}


	$date = "{0:G}" -f [System.DateTime]::get_Now()
	if (test-path $Logfile)
	{ Add-Content $Logfile "$date	$text" }
	Else
	{
	New-Item $logfile -ItemType File -force | out-null
	Set-Content $Logfile "$date	$text" 
	}
}


$Global:LogFile = "$env:windir\Logs\enableDEP.log"


Log("-----------------------------------------------------------------------------------")

$depstatus = Get-WmiObject Win32_OperatingSystem

if ($depstatus.DataExecutionPrevention_SupportPolicy -ne 3)

{

	[array]$bde = Get-WmiObject win32_EncryptableVolume -Namespace root\CIMv2\Security\MicrosoftVolumeEncryption
	
	if ($bde -lt 0) # No Encryptable volume available
		{
		&	bcdedit -set "{current}" nx optout
			if (!$?) {Log("Error:  $($error[0])")} Else { Log("Successfully run: bcdedit -set {current} nx optout") }
		}

	for ($i=0; $i -lt $bde.count; $i++)
	{

	if ($bde[$i].DriveLetter -eq "C:")
		{
		if ($bde[$i].ProtectionStatus -eq 0)
			{
		&	bcdedit -set "{current}" nx optout
			if (!$?) {Log("Error:  $($error[0])")} Else { Log("Successfully run: bcdedit -set {current} nx optout") }
			break
			}
		if ($bde[$i].ProtectionStatus -eq 1)
			{
			$bde[$i].DisableKeyProtectors()
			&	bcdedit.exe -set "{current}" nx Optout
			if (!$?) {Log("Error:  $($error[0])")} Else { Log("Successfully run: bcdedit -set {current} nx optout") }
			$bde[$i].EnableKeyProtectors()
			break
			}
		}
	Else
		{
		&	bcdedit -set "{current}" nx optout
			if (!$?) {Log("Error:  $($error[0])")} Else { Log("Successfully run: bcdedit -set {current} nx optout") }
			break
		}

	}



}

Else
	{
	Log("DEP already enabled")
	}

