CheckRegistry  = ReadRegStr (HKEY_LOCAL_MACHINE, "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\{ProductCode}", "DisplayName", 32) 'Checks if the mentioned registry is present in the 32bit hive
CheckRegistry2  = ReadRegStr (HKEY_LOCAL_MACHINE, "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\{ProductCode}", "DisplayName", 64) 'Checks if the mentioned registry is present in the 64bit hive

If CheckRegistry <>"" Then 'If the registry exists
 
	wscript.echo "32Bit Registry exists"

End If

If CheckRegistry2 <>"" Then 'If the registry exists
 
	wscript.echo "64Bit Registry exists"

End If

'################################################################################################################
'#	ReadRegStr function																				#
'################################################################################################################

Function ReadRegStr (RootKey, Key, Value, RegType)
    Dim oCtx, oLocator, oReg, oInParams, oOutParams

    Set oCtx = CreateObject("WbemScripting.SWbemNamedValueSet")
    oCtx.Add "__ProviderArchitecture", RegType

    Set oLocator = CreateObject("Wbemscripting.SWbemLocator")
    Set oReg = oLocator.ConnectServer("", "root\default", "", "", , , , oCtx).Get("StdRegProv")

    Set oInParams = oReg.Methods_("GetStringValue").InParameters
    oInParams.hDefKey = RootKey
    oInParams.sSubKeyName = Key
    oInParams.sValueName = Value

    Set oOutParams = oReg.ExecMethod_("GetStringValue", oInParams, , oCtx)

    ReadRegStr = oOutParams.sValue
End Function
