'-------------------------------------------------------------------------------------
'Checks if the registry key exists, and if it has any subkeys it deletes them all
'-------------------------------------------------------------------------------------
Const HKEY_CURRENT_USER  = &H80000001
Const HKEY_LOCAL_MACHINE = &H80000002


Set wmiLocator = CreateObject("WbemScripting.SWbemLocator")
Set wshNetwork = CreateObject("WScript.Network")
Set wmiNameSpace = wmiLocator.ConnectServer(wshNetwork.ComputerName, "root\default")
Set objRegistry = wmiNameSpace.Get("StdRegProv")

sPath = "Software\YourRegistry" 'Change here your registry key

lRC = DeleteRegEntry(HKEY_CURRENT_USER, sPath) 'Change here HKEY_CURRENT_USER with HKEY_LOCAL_MACHINE if you want to search in HKLM registry

Function DeleteRegEntry(sHive, sEnumPath)
lRC = objRegistry.DeleteKey(sHive, sEnumPath)

If (lRC <> 0) Then

   On Error Resume Next

   lRC = objRegistry.EnumKey(HKEY_CURRENT_USER, sEnumPath, sNames)

   For Each sKeyName In sNames
      If Err.Number <> 0 Then Exit For
      lRC = DeleteRegEntry(sHive, sEnumPath & "\" & sKeyName)
   Next

   On Error Goto 0

   lRC = objRegistry.DeleteKey(sHive, sEnumPath)

End If

End Function

